#ifndef __GraspBodyItem_H__
#define __GraspBodyItem_H__

#include <boost/dynamic_bitset.hpp>

#include "../../../src/BodyPlugin/SceneBody.h"
#include <cnoid/BodyItem>

#include "exportdef.h"


class EXCADE_API PlanBase;

namespace grasp{

class GraspBodyItem;
typedef boost::intrusive_ptr<GraspBodyItem> GraspBodyItemPtr;

class ExtSceneBody;

class EXCADE_API ExtSceneBody : public cnoid::SceneBody
{
	public:
		ExtSceneBody(cnoid::BodyItemPtr bodyItem) : SceneBody(bodyItem){ }
		
		static SceneBody* create(cnoid::BodyItemPtr bodyItem){
			return new ExtSceneBody(bodyItem) ;
		}

		virtual bool onKeyPressEvent(const cnoid::SceneViewEvent& event){
			cnoid::MessageView::mainInstance()->cout() << "ExtSceneBody::test" << std::endl;
			cnoid::SceneBody::onKeyPressEvent(event);
		}
/*		virtual bool onKeyReleaseEvent(const cnoid::SceneViewEvent& event){
		}
		virtual bool onButtonPressEvent(const cnoid::SceneViewEvent& event){
		}
		virtual bool onDoubleClickEvent(const cnoid::SceneViewEvent& event){
		}
		virtual bool onButtonReleaseEvent(const cnoid::SceneViewEvent& event){
		}
		virtual bool onPointerMoveEvent(const cnoid::SceneViewEvent& event){
		}
		virtual void onPointerLeaveEvent(const cnoid::SceneViewEvent& event){
		}
		virtual bool onScrollEvent(const cnoid::SceneViewEvent& event){
		}
*/
};
typedef boost::intrusive_ptr<ExtSceneBody> ExtSceneBodyPtr;


class EXCADE_API TestSceneBody : public ExtSceneBody
{
	public:
		TestSceneBody(cnoid::BodyItemPtr bodyItem) : ExtSceneBody(bodyItem){ }
		
		static SceneBody* create(cnoid::BodyItemPtr bodyItem){
			return new TestSceneBody(bodyItem) ;
		}

		virtual bool onKeyPressEvent(const cnoid::SceneViewEvent& event){
			cnoid::MessageView::mainInstance()->cout() << "TestSceneBody::test" << std::endl;
			ExtSceneBody::onKeyPressEvent(event);
		}
/*		virtual bool onKeyReleaseEvent(const cnoid::SceneViewEvent& event){
		}
		virtual bool onButtonPressEvent(const cnoid::SceneViewEvent& event){
		}
		virtual bool onDoubleClickEvent(const cnoid::SceneViewEvent& event){
		}
		virtual bool onButtonReleaseEvent(const cnoid::SceneViewEvent& event){
		}
		virtual bool onPointerMoveEvent(const cnoid::SceneViewEvent& event){
		}
		virtual void onPointerLeaveEvent(const cnoid::SceneViewEvent& event){
		}
		virtual bool onScrollEvent(const cnoid::SceneViewEvent& event){
		}
*/
};


class EXCADE_API GraspBodyItem : public cnoid::BodyItem
{
	public:
		GraspBodyItem(const BodyItem& org) : BodyItem(org){
			scene_ = NULL;
		}
		virtual cnoid::SgNode* scene(){
			if(!scene_){
				scene_ = (ExtSceneBody*)(factory(NULL))(this);
			}
			return scene_.get();
		}
		static boost::function<cnoid::SceneBody*(cnoid::BodyItem*)> factory(boost::function<cnoid::SceneBody*(cnoid::BodyItem*)> ext=NULL){
			static boost::function<cnoid::SceneBody*(cnoid::BodyItem*)> factory_ = ExtSceneBody::create;
			if(ext) factory_ = ext;
			return factory_;
		}
		ExtSceneBodyPtr scene_;
};

}

#endif