#ifndef _INTEROBJECT_H
#define _INTEROBJECT_H

#include <iostream>
#include <stdlib.h>
#include <time.h>
#include <cnoid/Item>
#include <cnoid/BodyItem>

#include "exportdef.h"

class EXCADE_API InterObject{
	public:
	cnoid::BodyItemPtr slaveItem;
	cnoid::Link *master;
	cnoid::Vector3 relativePos;
	cnoid::Matrix3 relativeRot;
	std::vector<cnoid::ColdetLinkPairPtr> slaveEnvPairs;
	int state;
	int type;
	
	enum InterObjectType{ ANIMATION, COLLISION, ROBOT, GRASPED_OBJECT};
	
	virtual void setInterObject();
	virtual void outputRelativePosition();
	virtual void initialCollision();
	virtual bool isColliding();
	
};

#endif
